/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.managed.UserRole;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Calendar;

public class ProductEngineeringUser
extends User {
    private static final String TRACE_MASKT = "XFRMPEUT";
    private static final String TRACE_MASKF = "XFRMPEUF";
    private static final String TRACE_MASKD = "XFRMPEUD";
    private static final String PEMODE = "PEMODE";
    private static ProductEngineeringUser peUser = null;

    public static synchronized ProductEngineeringUser getProductEngineeringUser() {
        if (peUser == null) {
            UIInfo uiInfo = new UIInfo(new LocalizableText(PEMODE), new LocalizableText("Product Engineering Mode User"));
            peUser = new ProductEngineeringUser(uiInfo);
            UserRole peRole = UserRole.getRole("base.rolegroup.pedebug");
            if (peRole != null) {
                peUser.addUserRole(peRole);
            }
            peUser.setEditable(false);
            peUser.setDisplayable(false);
            ManagedObjectManager.getManagedObjectManager().add(peUser);
        }
        return peUser;
    }

    private ProductEngineeringUser(UIInfo uiInfo) {
        super(PEMODE, PEMODE, uiInfo);
        Trace.trace(TRACE_MASKT, "<> ProductEngineeringUser()");
        this.setPersistent(false);
    }

    public boolean isPersistent() {
        return false;
    }

    public boolean isPasswordValid(String password) {
        boolean result = true;
        Trace.trace(TRACE_MASKT, "<> isPasswordValid(returns " + result + ")");
        return result;
    }

    public void changePassword(String oldPassword, String newPassword) throws UnsupportedOperationException {
        Trace.trace(TRACE_MASKT, "<> changePassword()");
        throw new UnsupportedOperationException("Password cannot be changed for product engineering users.");
    }

    public byte[] getPassword() {
        Trace.trace(TRACE_MASKT, "-> getPassword()");
        byte[] result = CommonSystem.getCommonSystem().hashPassword(this.getPasswordNotEncrypted());
        Trace.trace(TRACE_MASKT, "<- getPassword()");
        return result;
    }

    String getPasswordNotEncrypted() {
        Trace.trace(TRACE_MASKT, "-> getPassword()");
        Calendar cal = Calendar.getInstance();
        long ulSerial = 0L;
        int iyear = cal.get(1);
        int imonth = cal.get(2);
        int iday = cal.get(5);
        short year = (short)cal.get(1);
        char month = (char)(cal.get(2) - 0 + 1);
        char day = (char)cal.get(5);
        StringBuffer serial = new StringBuffer("000000000000");
        String tempSerial = "";
        try {
            VpdManager vpdMan = VpdManager.getVpdManager();
            VpdData vpdConfigData = new VpdData(VpdRequestValue.CONFIG_REQUEST);
            vpdConfigData = vpdMan.callVpdManager(vpdConfigData);
            tempSerial = vpdConfigData.getVpdConfigurationExistData().getMachineSerial();
        }
        catch (Exception e) {
            System.out.println("Exception in VpdManager");
        }
        if (tempSerial.length() > serial.length()) {
            serial.replace(0, serial.length(), tempSerial.substring(tempSerial.length() - serial.length()));
        } else {
            serial.replace(serial.length() - tempSerial.length(), serial.length(), tempSerial);
        }
        int iCount = 4;
        while (iCount <= 11) {
            ulSerial <<= 4;
            ulSerial |= (long)this.atoh(serial.charAt(iCount));
            ++iCount;
        }
        long ulWork = this.tablemutate(ulSerial, 0);
        ulWork = this.scramble(ulWork);
        long ulTemp = (long)year * 983L;
        ulTemp += (long)month * 41L;
        ulTemp += (long)day;
        ulTemp = this.scramble(ulTemp);
        ulWork = this.tablemutate(ulWork, 1);
        String pswd = Long.toHexString(ulWork ^= ulTemp).toUpperCase();
        while (pswd.length() < 8) {
            pswd = "0" + pswd;
        }
        Trace.trace(TRACE_MASKT, "<- getPasswordNotEncrypted()");
        return pswd;
    }

    public void setPassword(String password) {
    }

    public boolean isDisplayable() {
        return false;
    }

    public void setDisabled(boolean disabled) throws UnsupportedOperationException {
        Trace.trace(TRACE_MASKT, "<> setDisabled()");
        throw new UnsupportedOperationException("The product engineering user cannot be disabled.");
    }

    public boolean isDisabled() {
        Trace.trace(TRACE_MASKT, "<> isDisabled()");
        return !BaseTower.getBaseTower().isPEAccessEnabled();
    }

    private int atoh(char ucCharIn) {
        int uHexOut = ucCharIn >= '0' && ucCharIn <= '9' ? ucCharIn - 48 : (ucCharIn >= 'a' && ucCharIn <= 'f' ? ucCharIn - 97 + 10 : (ucCharIn >= 'A' && ucCharIn <= 'F' ? ucCharIn - 65 + 10 : 0));
        return uHexOut;
    }

    private long tablemutate(long ulIn, int iTable) {
        long ulOut = 0L;
        int[] ucTable1 = new int[]{73, 41, 138, 86, 60, 190, 63, 111, 183, 136, 85, 109, 224, 108, 196, 68, 95, 157, 225, 211, 161, 112, 18, 12, 67, 38, 123, 6, 200, 171, 137, 17, 46, 209, 237, 91, 169, 22, 122, 34, 98, 83, 162, 58, 23, 153, 141, 78, 100, 154, 245, 15, 206, 188, 216, 170, 70, 81, 228, 94, 250, 64, 121, 1, 66, 89, 248, 221, 44, 176, 31, 127, 28, 255, 30, 168, 29, 25, 131, 49, 186, 56, 19, 214, 37, 87, 47, 230, 185, 74, 135, 236, 178, 32, 229, 203, 205, 33, 140, 96, 242, 77, 179, 88, 118, 184, 5, 207, 125, 11, 254, 238, 156, 50, 107, 163, 92, 149, 61, 241, 217, 129, 16, 134, 69, 139, 145, 239, 181, 182, 106, 189, 104, 75, 128, 215, 71, 65, 227, 113, 82, 43, 246, 3, 223, 124, 102, 80, 243, 101, 194, 165, 116, 174, 155, 233, 115, 40, 9, 120, 164, 26, 54, 247, 180, 150, 8, 20, 24, 193, 240, 172, 27, 192, 195, 13, 35, 249, 103, 14, 158, 177, 59, 232, 93, 4, 51, 252, 213, 218, 152, 234, 151, 222, 132, 244, 39, 114, 253, 197, 42, 97, 76, 7, 251, 10, 99, 72, 117, 159, 204, 48, 53, 62, 36, 119, 148, 220, 191, 175, 126, 212, 133, 235, 226, 55, 202, 187, 210, 142, 90, 147, 198, 146, 219, 2, 160, 208, 201, 130, 173, 84, 79, 105, 231, 144, 167, 166, 110, 21, 52, 0, 143, 57, 45, 199};
        int[] ucTable2 = new int[]{63, 12, 235, 165, 194, 173, 203, 11, 7, 179, 78, 117, 163, 217, 144, 2, 94, 8, 145, 71, 97, 64, 197, 241, 115, 190, 65, 103, 55, 252, 24, 33, 17, 106, 171, 234, 128, 250, 188, 10, 79, 95, 187, 118, 9, 36, 238, 32, 209, 126, 70, 229, 91, 124, 26, 196, 159, 176, 215, 254, 80, 85, 230, 242, 155, 25, 108, 0, 35, 160, 109, 231, 182, 51, 41, 122, 66, 181, 56, 27, 130, 210, 60, 222, 111, 243, 6, 244, 236, 119, 249, 131, 37, 201, 207, 14, 42, 166, 3, 216, 247, 137, 114, 245, 172, 59, 184, 214, 48, 133, 125, 156, 110, 169, 147, 218, 18, 255, 75, 76, 170, 150, 225, 248, 53, 84, 228, 192, 141, 61, 29, 116, 153, 5, 123, 54, 149, 89, 164, 69, 251, 152, 39, 87, 143, 83, 23, 191, 30, 132, 99, 81, 139, 74, 227, 4, 50, 154, 177, 211, 44, 202, 77, 46, 246, 34, 240, 92, 161, 82, 205, 167, 19, 47, 199, 112, 13, 178, 213, 101, 67, 233, 204, 107, 20, 102, 195, 127, 121, 140, 134, 93, 1, 200, 68, 220, 239, 208, 120, 45, 28, 224, 221, 186, 21, 157, 135, 232, 158, 223, 226, 15, 136, 189, 148, 129, 62, 151, 162, 72, 73, 113, 49, 40, 38, 57, 86, 219, 16, 105, 237, 146, 183, 58, 100, 185, 253, 138, 174, 98, 198, 175, 31, 212, 88, 193, 142, 43, 180, 104, 22, 168, 206, 96, 90, 52};
        int iCount = 3;
        while (iCount >= 0) {
            ulOut <<= 8;
            ulOut = iTable != 0 ? (ulOut |= (long)ucTable2[(int)ulIn & 0xFF] & 0xFFL) : (ulOut |= (long)ucTable1[(int)ulIn & 0xFF] & 0xFFL);
            ulIn >>= 8;
            --iCount;
        }
        return ulOut;
    }

    private long scramble(long ulIn) {
        short usRemainder;
        long ulWork2;
        long ulWork = ulIn;
        long ulOut = 0L;
        int iCount = 3;
        while (iCount >= 0) {
            ulWork2 = ulWork / 229L;
            usRemainder = (short)(ulWork % 229L);
            ulOut <<= 8;
            ulOut |= (long)usRemainder;
            ulWork = ulWork2;
            --iCount;
        }
        ulWork = ulOut;
        ulOut = 0L;
        int iCount2 = 3;
        while (iCount2 >= 0) {
            ulWork2 = ulWork / 191L;
            usRemainder = (short)(ulWork % 191L);
            ulOut <<= 8;
            ulOut |= (long)usRemainder;
            ulWork = ulWork2;
            --iCount2;
        }
        return ulOut;
    }
}

